<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsd="http://www.w3.org/2000/10/XMLSchema"
	xmlns:wsdl="http://schemas.xmlsoap.org/wsdl/"
	xmlns:soap="http://schemas.xmlsoap.org/wsdl/soap/"
	xmlns:http="http://schemas.xmlsoap.org/wsdl/http/"
	xmlns:mime="http://schemas.xmlsoap.org/wsdl/mime/">


<xsl:param name="service" select="'ALL'"/>
<xsl:param name="port" select="'ALL'"/>
<xsl:param name="binding" select="'ALL'"/>
<xsl:param name="portType" select="'ALL'"/>


<xsl:output method="html"/>

  <xsl:template match="/">
      <html>
      <head>
        <title>ACME Web Services, Inc. Query Result</title>
        <xsl:comment>WSDL Documentation: Generated by wsdlServiceList.xslt</xsl:comment>
      </head>
      <body>
        <xsl:apply-templates select="wsdl:definitions"/> 
      </body>
    </html>
</xsl:template>

<xsl:template match="wsdl:definitions">
   <xsl:variable name="result">
        <xsl:apply-templates select="wsdl:service[$service = 'ALL' or @name = $service]"/> 
  </xsl:variable>
  <xsl:choose>
    <xsl:when test="normalize-space($result)">
      <xsl:copy-of select="$result"/>
    </xsl:when>
    <xsl:otherwise>
      <p><b>No Matching Services Found</b></p>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="wsdl:service">
   <xsl:if test="$port = 'ALL' or wsdl:port/@name = $port">
     <xsl:variable name="thisBinding" select="substring-after(wsdl:port[@name = $port]/@binding,':')"/>
        <xsl:if test="$binding = 'ALL'  or $thisBinding = $binding">
           <xsl:variable name="thisType" 
                                  select="substring-after(/wsdl:definitions/wsdl:binding[@name = $thisBinding]/@type,':')"/>
           <xsl:if test="$portType = 'ALL' or $thisType = $portType">
             <xsl:call-template name="format-service">
               <xsl:with-param name="thisBinding" select="$thisBinding"/>
             </xsl:call-template>
           </xsl:if> 
        </xsl:if>
   </xsl:if>
</xsl:template>

<xsl:template name="format-service">
<xsl:param name="thisBinding"/>

<h1><xsl:value-of select="@name"/></h1>
<p><xsl:value-of select="wsdl:documentation"/></p>
<table border="1" cellpadding="5" cellspacing="0"  width="600">
  <tbody>
    <tr>
      <td style="font-weight:bold" width="50">Port</td>
      <td><xsl:value-of select="wsdl:port/@name"/></td>
    </tr>
    <tr>
      <td style="font-weight:bold" width="50">Binding</td>
      <td><xsl:value-of select="substring-after(wsdl:port/@binding,':')"/></td>
    </tr>
    <tr>
      <td style="font-weight:bold" width="50">Address</td>
      <td><xsl:value-of select="wsdl:port/soap:address/@location"/></td>
    </tr>
    <tr>
      <th colspan="2" align="center">Operations</th>
    </tr>
    <xsl:apply-templates select="/*/wsdl:binding[@name=$thisBinding] " mode="display"/>
  </tbody>
</table>
</xsl:template>

<xsl:template match="wsdl:binding" mode="display">
  <xsl:variable name="type" select="substring-after(@type,':')"/>
  <xsl:apply-templates select="/*/wsdl:portType[@name=$type]" mode="display"/>
</xsl:template>

<xsl:template match="wsdl:portType" mode="display">
  <xsl:for-each select="wsdl:operation">
    <tr>
      <td colspan="2"><h3><xsl:value-of select="@name"/></h3></td>
    </tr>
    <xsl:if test="wsdl:input">
      <tr>
        <td style="font-weight:bold" width="50">Input</td>
        <td><xsl:value-of select="substring-after(wsdl:input/@message,':')"/></td>
      </tr>
      <xsl:variable name="msgName" select="substring-after(wsdl:input/@message,':')"/>
      <xsl:apply-templates select="/*/wsdl:message[@name = $msgName]" mode="display"/>
    </xsl:if>
    <xsl:if test="wsdl:output">
      <tr>
        <td style="font-weight:bold" width="50">Output</td>
        <td><xsl:value-of select="substring-after(wsdl:output/@message,':')"/></td>
      </tr>
      <xsl:variable name="msgName" select="substring-after(wsdl:output/@message,':')"/>
      <xsl:apply-templates select="/*/wsdl:message[@name = $msgName]" mode="display"/>
   </xsl:if>
  </xsl:for-each>
</xsl:template>

<xsl:template match="wsdl:message" mode="display">
  <xsl:variable name="dataType" select="substring-after(wsdl:part[@name='body']/@element,':')"/>
  <tr>
    <td colspan="2">
      <xsl:apply-templates  select="/*/wsdl:types/*/*[@name=$dataType]" mode="display">
        <xsl:with-param name="initial-newline" select="false()"/>
      </xsl:apply-templates>
    </td>
  </tr>
</xsl:template>

<!-- This code is used to render the xsd schema of messages as xml within html-->

<xsl:template match="*" mode="display">
  <xsl:param name="initial-newline" select="true()"/>
  
  <xsl:if test="$initial-newline">
    <xsl:call-template name="newline"/>
  </xsl:if>
  <!-- open tag -->
  <a style="color:blue">&lt;</a>
  <a style="color:darkred"><xsl:value-of select="name(.)" /> </a>
  
  <!-- Output attributes -->
  <xsl:for-each select="@*">
    <a style="color:red"><xsl:text> </xsl:text><xsl:value-of select="name(.)" />  </a>
    <a style="color:blue">=&quot;</a>
    <xsl:value-of select="." />
    <a style="color:blue">&quot;</a>
  </xsl:for-each>
  
  <xsl:choose>
  	<xsl:when test="child::node()">
        <!-- close start tag -->
        <a style="color:blue">&gt;</a>
        <xsl:apply-templates  mode="display"/>
        <xsl:call-template name="newline"/>
        <!-- closing tag -->
        <a style="color:blue">&lt;</a>
        <a style="color:darkred">/<xsl:value-of select="name(.)" /></a>
  	</xsl:when>
  	<xsl:otherwise>
  		<a style="color:blue">/</a>
  	</xsl:otherwise>
  </xsl:choose>
  <a style="color:blue">&gt;</a>
</xsl:template>

<!-- Add a newline and then indent based on depth within the schema -->
<xsl:template name="newline">
	<br/>
	<xsl:for-each select="ancestor::xsd:*[not(self::xsd:schema)]">
		<xsl:text>&#160;&#160;&#160;&#160;</xsl:text>
	</xsl:for-each>
</xsl:template>

</xsl:stylesheet>
